///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL TELECOMMUNICATIONS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   utilfun.h - Utility Function Protoype Headers
// 
//
//   DESCRIPTION
//
//   This header function declares prototypes for the utility functions
//
//
//   REVISION HISTORY (ORIGINAL AUTHOR: Keith Brodie)
//
//   $Log:   V:\Projects\Labmon\Include\Archives\UTILFUN.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:52   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.3   Jul 09 1997 10:31:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:04:48   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:14:36   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:32   GPSADMIN
//   Initial release to version control.
//   
//      Rev 1.7   Aug 14 1995 16:02:04   BRODIE
//   Added 'const' qualifier to utc time conversion
//   function input arguments, they should not be
//   modified by the time conversion routines.
//   
//   
//      Rev 1.6   Aug 07 1995 18:27:58   BRODIE
//   Added macros mDSQRT and mFSQRT for protected
//    floating point square roots.
//   
//      Rev 1.5   Jul 25 1995 08:18:14   SHAHEEN
//   Added prototypes for 3 new functions, for converting between double
//   and signed and unsigned tripple integers.
//   
//   
//      Rev 1.4   Jun 15 1995 16:12:52   BRODIE
//   Changed calling sequence in UTC conversion prototypes.
//   
//      Rev 1.3   Jun 13 1995 12:18:54   BRODIE
//   Added declaration of gps2utc routine.
//   
//      Rev 1.2   Jun 12 1995 16:20:54   BRODIE
//   Added mMin and mMax macros for min & max.
//   
//      Rev 1.1   Jun 12 1995 15:17:12   BRODIE
//   Changed utc2gps week and tow pointers from signed to unsigned.
//   
//      Rev 1.0   Jun 07 1995 18:43:20   BRODIE
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL CONFIDENTIAL AND PROPRIETARY
//
//   This source is the sole property of Rockwell International.  Reproduction
//   or utilization of this source in whole or in part is forbidden without
//   the written consent of Rockwell International.
//
//   (c) Copyright Rockwell International, 1995.  All Rights Reserved.
//
////////////////////////////////////////////////////////////////////////////////

#ifndef UTILFUN_H
#define UTILFUN_H
                     
  #include "gentypes.h"
  #include "hrtc.h"
  #include "navtypes.h"

  #define mMax(a,b)    (((a) > (b)) ? (a) : (b))
  #define mMin(a,b)    (((a) < (b)) ? (a) : (b))        
  
  #define mDSQRT(x) ((double)sqrt((double)mMax((x),0.0)))
  #define mFSQRT(x) ((float)sqrt((float)mMax((x),0.0F)))

  extern long CalcCheckSum (short *data, short length);

  extern short utc2gps (const tUTCtime *UTCtime, const short leapsec, tGPStime *GPStime);
   
  extern short gps2utc (const tGPStime *GPStime, const double dtUTC, tExtUTCtime *UTCtime);
   
  extern double utrip2dbl (tUTRIPLE *x);

  extern tDOUBLE trip2dbl (tTRIPLE *x);

  extern void dbl2utrip (tDOUBLE fpval, tUTRIPLE *x);

  extern void dbl2trip (tDOUBLE fpval, tTRIPLE *x);
   
#endif
